<?php

function generate_config()
{
    include_once("../config/node_parameters.php");  /* DO NOT DELETE THIS LINE */ //All link parameters
    
    
return "
    
# JUNIPER Configuration on device IP: $IP
# ########################################################################## !!

set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC description $MAP_NAME
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC encapsulation vlan-ccc
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC vlan-id-list $C_VLAN
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC input-vlan-map push
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC input-vlan-map vlan-id $S_VLAN
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC output-vlan-map pop
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family ccc policer input $MAP_NAME-IN
set  interfaces $INTERFACE_SRC unit $SUBINTERFACE_SRC family ccc policer output $MAP_NAME-OUT

##### Policers ##############################################################################################

set  firewall policer $MAP_NAME-IN if-exceeding bandwidth-limit $UPLOAD
set  firewall policer $MAP_NAME-IN if-exceeding burst-size-limit 10m
set  firewall policer $MAP_NAME-IN then discard

set  firewall policer $MAP_NAME-OUT if-exceeding bandwidth-limit $DOWNLOAD
set  firewall policer $MAP_NAME-OUT if-exceeding burst-size-limit 10m
set  firewall policer $MAP_NAME-OUT then discard

set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC virtual-circuit-id $C_VLAN
set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC encapsulation-type ethernet
#set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC encapsulation-type ethernet-vlan
set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC flow-label-transmit
set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC flow-label-receive
set  protocols l2circuit neighbor $NEIGHBOR_DST interface $INTERFACE_SRC.$SUBINTERFACE_SRC mtu 9000

";

}

?>
